-- Freedom_Opener.lua
-- Author: Machiavelli
-- DateCreated: 6/1/2012 7:39:17 AM
--------------------------------------------------------------
function GiveCultureWhenGreatPersonCreated(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	local player = Players[playerID];
	local unit = player:GetUnitByID(unitID);
	local policyID = GameInfoTypes["POLICY_FREEDOM"];

	-- Only give the Culture if the player has the policy and this is a great person
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and unit:IsGreatPerson()) then
		local bonusCulture = 250;
		-- Adjust the size of the bonus based on the game speed
		local speedCulturePercent = GameInfo.GameSpeeds[Game:GetGameSpeedType()].CulturePercent;
		local adjustedBonusCulture = (bonusCulture * speedCulturePercent) / 100;
		-- Give the culture
		player:SetJONSCulture(player:GetJONSCulture() + adjustedBonusCulture);

		-- Send a notification to the player
		local text = Locale.ConvertTextKey("TXT_KEY_REWARD_FROM_GREAT_PERSON_BIRTH", tostring(adjustedBonusCulture), unit:GetName());
		player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);
	end
end
LuaEvents.SerialEventUnitCreatedGood.Add(GiveCultureWhenGreatPersonCreated);